clc;
clear;

global m

% Input parameters
% ----------------

dt = 0.01;

ki = 1;

t = (0:0.1:1440);
ki=[ ];
p=pi();

for i=1:length(t)
    if sin((2*p*((t(i)/60)-6))/24) > 0
        ku=sin((2*p*((t(i)/60)-6))/24);
        ki=[ku ki];
    else
        ku=0;
        ki=[ku ki];
    end
end


m.k1 = 0.533*ki;
m.k2 = 2.21*10^(-5);
m.k3 = 26.7;
m.k4a = 1.6*10^(-3*ki);
m.k4b = 2.11*10^(-3)*ki;
m.k5 = 1.62*10^4;
m.k6 = 1.22*10^4;
m.k7 = 1.62*10^4;

% Initial conditions
% ------------------

Cstart = zeros(13,1);

Cstart(1) = 0.01;                    % NO   --> dC(1); C(1)
Cstart(2) = 0.1;                     % NO2  --> dC(2); C(2)
Cstart(3) = 0;                       % O    --> dC(3); C(3)
Cstart(4) = 0;                       % O3   --> dC(4); C(4)
Cstart(5) = 0;                       % HO2  --> dC(5); C(5)
Cstart(6) = 0;                       % H2   --> dC(6); C(6)
Cstart(7) = 0;                       % HNO3 --> dC(7); C(7)
Cstart(8) = 0;                       % H2O  --> dC(8); C(8)
Cstart(9) = 0.1;                     % CHOH --> dC(9); C(9)
Cstart(10) = 0;                      % CO   --> dC(10); C(10)
Cstart(11) = 0;                      % OH   --> dC(11); C(11)
Cstart(12) = 0.21*10^6;              % O2   -->dC(12); C(12)
Cstart(13) = 10^6;                   % M    -->dc(13); C813

t = (0:dt:1440);

[t,C] = ode15s (@Pollution_model, t, Cstart);

figure(1)
plot(t/60,C(:,1:11),'-')
xlabel ('Temps [h]')
ylabel ('concentration [ppm]')
title ('Variation d espce prsente dans l air en fonction du temps')
legend ('NO', 'NO2', 'O', 'O3', 'HO2', 'H2', 'HNO3', 'H2O', 'CHOH', 'CO', 'OH', 'O2', 'M')
